﻿var responses = {
    context: $(".v-responses"),
    responseEditorContext: $(".v-responseEditor", this.context),
    datatable: null,
    respondentId: $("#RespondentId").val(),
    initialize: function () {
        var displayRowColumn = $("#DisplayRowColumn", this.context).val() == "True";

        var columns = [
            { "Name": "Position", "Title": "#", "Data": "Position", "Type": "numeric" },
            { "Name": "Block", "Title": resources.Block, "Data": "Block" },
            { "Name": "Question", "Title": resources.Question, "Data": "Question" },
            { "Data": "QuestionText", "Tooltip": true, "Icon": "fa fa-info-circle" },
            { "Name": "Variable", "Title": resources.Variable, "Data": "Variable" },
            { "Name": "Content", "Title": resources.Answer, "Data": "Answer", "Width": "30%", "EncodeHtml": true },
            { "Name": "OpenEnd", "Title": resources.OpenEnd, "Data": "OpenEnd", "Sortable": false, "EncodeHtml": true }
        ];

        if (displayRowColumn) {
            columns.splice(5, 0, { "Name": "Row", "Title": resources.Row, "Data": "Row" });
        }

        this.datatable = $(".h-responsesTable", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getSurveyAction("GetResponses", "Analyze"),
            ajaxParams: { "respondentId": responses.respondentId },
            columns: columns,
            stateKey: "Responses",
            contextMenuItems: responses.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        responses.showResponseEditor(row.Variable, row.Row, row.VariableDataTypeValue);
                        break;
                    case "clear":
                        modalDialog.showConfirmDialog(confirmClearResponseResources, function () {
                            a4.callServerMethod(a4.getSurveyAction("ClearResponse", "Analyze"), { respondentId: responses.respondentId, variableName: row.Variable, matrix: row.Row }, function (result) {
                                responses.refreshContent();
                            });
                        }, 220, 500, false, {});
                        break;
                }
            }
        });
    },  
    getContextMenuItems: function () {
        return (isReadonly) ? [] : [
            { "Action": "clear", "Label": resources.Clear, "DisplayCondition": function (data) { return data.IsPersonalInformationObfuscated == false; } },
            { "Action": "edit", "Label": resources.Edit, "DisplayCondition": function (data) { return data.VariableDataTypeValue != Enum.VariableDataType.File && data.IsPersonalInformationObfuscated == false && data.IsEditButtonEnabled == false;} },
        ];
    },
    bindEvents: function () {
        this.context.on("click", ".v-responseEditorFooter .h-cancelEditResponse", function () {
            responses.hideResponseEditor();
        });

        this.context.on("click", ".v-responseEditorFooter .h-saveEditResponse", function () {
            responses.saveResponse();
        });
    },
    initializeEditor: function () {
        $(':text[data-questiontype="DateTimeAnswer"]', responses.responseEditorContext).each(function () {
            var dateType = $(this).attr("data-datetype");
            var dateFormat = $(this).attr("data-dateformat");
            var timeFormat = $(this).attr("data-timeformat");
            var ampm = timeFormat.indexOf("t") != -1;

            switch (dateType) {
                case "Date":
                    $(this).datepicker({
                        changeMonth: true,
                        changeYear: true,
                        yearRange: 'c-50:c+10',
                        dateFormat: dateFormat
                    });
                    break;
                case "DateTime":
                    $(this).datetimepicker({
                        ampm: ampm,
                        changeMonth: true,
                        changeYear: true,
                        yearRange: 'c-50:c+10',
                        dateFormat: dateFormat,
                        timeFormat: timeFormat
                    });
                    break;
                case "Time":
                    $(this).timepicker({
                        ampm: ampm,
                        timeFormat: timeFormat
                    });
                    break;
            }
        });

        $(':text[data-variabletype="Numeric"]', responses.responseEditorContext).autoNumeric({ aSep: '', aDec: '.', aPad: false, vMin: -Number.MAX_VALUE, vMax: Number.MAX_VALUE });
    },
    bindEditorEvents: function () {
        responses.responseEditorContext.on("change", ".v-choiceList :input", function () {
            $(".v-textAnswer :input", responses.responseEditorContext).val("");
        });

        responses.responseEditorContext.on("change", ".v-textAnswer :input", function () {
            $(".v-choiceList :input", responses.responseEditorContext).prop("checked", false).attr("checked", false);
        });

        responses.responseEditorContext.on("change", ".v-choiceList .h-hasOpenEnd", function () {
            var choice = $(this).closest(".choice");
            $(".v-openEnd", choice).prop("disabled", !$(this).is(":checked"));
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    updateConfig: function (dataTable) {
        if (!configuration)
            configuration = {};

        if (dataTable) {
            configuration.dataTable = dataTable;
        }

        a4.callServerMethod(a4.getSurveyAction("UpdateResponsesUserPageConfiguration", "Analyze"), { settings: JSON.stringify(configuration) }, function (result) { });
    },
    showResponseEditor: function (variableName, matrix, variableDataType) {
        a4.callServerMethod(a4.getSurveyAction("GetResponseEditor", "Analyze"), { respondentId: responses.respondentId, variableName: variableName, matrix: matrix }, function (result) {
            responses.responseEditorContext.html(result);
            responses.initializeEditor();
        });

        $(".h-responsesTable", this.context).hide("slide", { direction: "left" }, 300, function () {
            responses.responseEditorContext.show("slide", { direction: "right" }, 300);
        });

        $(".v-responsesFooter", this.context).hide();
        $(".v-responseEditorFooter", this.context).show();
        $(".v-responseEditorFooter .h-saveEditResponse", this.context).toggle(variableDataType != Enum.VariableDataType.Base64);
    },
    hideResponseEditor: function () {
        responses.responseEditorContext.hide();
        $(".h-responsesTable", this.context).show("slide", { direction: "left" }, 300);
        $(".v-responseEditor", this.context).html("");

        $(".v-responseEditorFooter", this.context).hide();
        $(".v-responsesFooter", this.context).show();
    },
    saveResponse: function () {
        var mentions = [];
        var questionType = $(".v-questionType", responses.responseEditorContext).val();
        var isValid = true;
        var invalidInput;
        var errorMessage;

        //DragDropRanking
        if (questionType == "DragDropRanking" || questionType == "NumericRanking") {
            $(".v-dragDropRanking > div", responses.responseEditorContext).each(function () {
                var mention = $(this).attr("data-position");
                var value = $(this).find("select").val();

                if (value) {
                    mentions.push({ Mention: mention, Value: value });
                }
            });
        }
        else if (questionType == "LookupTable") {
            var i = 1;

            $(".v-continuousVariable", responses.responseEditorContext).each(function () {
                var value = $(this).find("input").val();

                if (value) {
                    mentions.push({ Mention: i++, Value: value });
                }
            });
        }
        else {
            //Choices
            $(".v-choiceList :input:checked", responses.responseEditorContext).each(function (index) {
                var choice = $(this).closest(".choice");
                var value = $(this).val();
                var openEnd = $(".v-openEnd", choice).val();

                mentions.push({ Mention: index + 1, Value: value, OpenEnd: openEnd });
            });

            var continuousVariable = $(".v-continuousVariable", responses.responseEditorContext);
            var openEndVariable = $(".v-openEndVariable", responses.responseEditorContext);

            if (continuousVariable.length > 0 && mentions.length == 0) {
                var value = $(":input", continuousVariable).val();
                mentions.push({ Mention: 1, Value: value });

                if (questionType == "RespondentEmail" || questionType == "EmailAddressAnswer") {
                    if (value && !a4.validateEmail(value)) {
                        isValid = false;
                        invalidInput = $(":input", continuousVariable);
                        errorMessage = resources.EmailInvalid;
                    }
                }
            }
            else if (openEndVariable.length > 0) {
                var openEnd = $(":input", openEndVariable).val();

                if (mentions.length == 0) {
                    var value = openEndVariable.attr("data-answercode");
                    mentions.push({ Mention: 1, Value: value, OpenEnd: openEnd });
                }
                else {
                    mentions[0].OpenEnd = openEnd
                }
            }
        }

        var variableName = $(".v-variableName", responses.responseEditorContext).val();
        var matrix = $(".v-matrixNumber", responses.responseEditorContext).val();

        if (isValid) {
            a4.callServerMethod(a4.getSurveyAction("UpdateResponse", "Analyze"), { respondentId: responses.respondentId, variableName: variableName, matrix: matrix, responses: mentions }, function (result) {
                responses.refreshContent();
                responses.hideResponseEditor();
            });
        }
        else {
            invalidInput.addClass("input-validation-error");
            $(".v-errorMessage", responses.responseEditorContext).text(errorMessage);
        }
    }
}

$(document).ready(function () {
    if (responses.context.length > 0) {
        responses.initialize();
        responses.bindEvents();
        responses.bindEditorEvents();
    }
});